#include <iostream>
#include <vector>

bool AllZero (std::vector<long long> arr) {
    for (int i = 0; i < arr.size(); ++i) {
        if(arr[i] != 0) return false;
    }

    return true;
}

struct line {
    long long startPos, endPos;
};

int main()
{
    std::vector<long long> arr;
    long long N; std::cin >> N; arr.resize(N);

    for (int i = 0; i < N; ++i) std::cin >> arr[i];

    long long res = 0, maxCount = 0;

    while (!AllZero(arr)) {
        for (int i = 0; i < N; ++i) {
            maxCount = std::max(arr[i], maxCount);
        }

        std::vector<line> removeablePositions;
        bool CanChangeStartPos = true;
        line Line; Line.startPos = -1; Line.endPos = -1;

        for (int i = 0; i < N; ++i) {
            if (arr[i] == maxCount) {
                if (CanChangeStartPos) {
                    Line.startPos = i;
                    CanChangeStartPos = false;
                }

                if (arr[i+1] != maxCount) {
                    Line.endPos = i;
                    removeablePositions.push_back(Line);
                    CanChangeStartPos = true;

                    Line.startPos = -1; Line.endPos = -1;
                }
            }
        }

        if (Line.startPos != -1) {
            Line.endPos = N-1;
            removeablePositions.push_back(Line);
        }

        int SizeArr = removeablePositions.size();
        res += SizeArr;

        for (int i = 0; i < SizeArr; ++i) {
            for (int j = removeablePositions[i].startPos; j <= removeablePositions[i].endPos; ++j) {
                arr[j]--;
            }
        }

        while (removeablePositions.size() > 0)
            removeablePositions.pop_back();

        SizeArr = 0; Line.startPos = -1; Line.endPos = -1; maxCount = 0;
    }

    std::cout << res;

    return 0;
}
